% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 28Mar2012
function HWM = calculate_HWM(AssetValues)
% check if empty vector
if isempty(AssetValues)
    error 'Vector AssetValues cannot be empty'
end
% check the size of vector
[rows,cols] = size(AssetValues);
if min(rows,cols) ~= 1
    error 'AssetValues must be a 1xN or Nx1 matrix'
end
% return a horizontal vector
if cols == 1
    AssetValues = AssetValues';
end

VectorLen = length(AssetValues);
HWM = zeros(1, VectorLen);
HWM(1) = AssetValues(1);

for i=2:VectorLen
    if AssetValues(i) > HWM(i-1)
        HWM(i) = AssetValues(i);
    else
        HWM(i) = HWM(i-1);
    end
end